var $19S5E$reactariafocus = require("@react-aria/focus");
var $19S5E$reactariautils = require("@react-aria/utils");
var $19S5E$react = require("react");
var $19S5E$reactariai18n = require("@react-aria/i18n");
var $19S5E$reactariainteractions = require("@react-aria/interactions");


function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "useDatePickerGroup", () => $715562ad3b4cced4$export$4a931266a3838b86);





function $715562ad3b4cced4$export$4a931266a3838b86(state, ref, disableArrowNavigation) {
    let { direction: direction } = (0, $19S5E$reactariai18n.useLocale)();
    let focusManager = (0, $19S5E$react.useMemo)(()=>(0, $19S5E$reactariafocus.createFocusManager)(ref), [
        ref
    ]);
    // Open the popover on alt + arrow down
    let onKeyDown = (e)=>{
        if (!e.currentTarget.contains(e.target)) return;
        if (e.altKey && (e.key === 'ArrowDown' || e.key === 'ArrowUp') && 'setOpen' in state) {
            e.preventDefault();
            e.stopPropagation();
            state.setOpen(true);
        }
        if (disableArrowNavigation) return;
        switch(e.key){
            case 'ArrowLeft':
                e.preventDefault();
                e.stopPropagation();
                if (direction === 'rtl') focusManager.focusNext();
                else focusManager.focusPrevious();
                break;
            case 'ArrowRight':
                e.preventDefault();
                e.stopPropagation();
                if (direction === 'rtl') focusManager.focusPrevious();
                else focusManager.focusNext();
                break;
        }
    };
    // Focus the first placeholder segment from the end on mouse down/touch up in the field.
    let focusLast = ()=>{
        var _window_event;
        // Try to find the segment prior to the element that was clicked on.
        let target = (_window_event = window.event) === null || _window_event === void 0 ? void 0 : _window_event.target;
        let walker = (0, $19S5E$reactariafocus.getFocusableTreeWalker)(ref.current, {
            tabbable: true
        });
        if (target) {
            walker.currentNode = target;
            target = walker.previousNode();
        }
        // If no target found, find the last element from the end.
        if (!target) {
            let last;
            do {
                last = walker.lastChild();
                if (last) target = last;
            }while (last);
        }
        // Now go backwards until we find an element that is not a placeholder.
        while(target === null || target === void 0 ? void 0 : target.hasAttribute('data-placeholder')){
            let prev = walker.previousNode();
            if (prev && prev.hasAttribute('data-placeholder')) target = prev;
            else break;
        }
        if (target) target.focus();
    };
    let { pressProps: pressProps } = (0, $19S5E$reactariainteractions.usePress)({
        preventFocusOnPress: true,
        allowTextSelectionOnPress: true,
        onPressStart (e) {
            if (e.pointerType === 'mouse') focusLast();
        },
        onPress (e) {
            if (e.pointerType !== 'mouse') focusLast();
        }
    });
    return (0, $19S5E$reactariautils.mergeProps)(pressProps, {
        onKeyDown: onKeyDown
    });
}


//# sourceMappingURL=useDatePickerGroup.main.js.map
