import {getNthItem as $kbsd1$getNthItem, getChildNodes as $kbsd1$getChildNodes, getLastItem as $kbsd1$getLastItem, getFirstItem as $kbsd1$getFirstItem} from "@react-stately/collections";
import {Rect as $kbsd1$Rect} from "@react-stately/virtualizer";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

class $d1c300d9c497e402$export$de9feff04fda126e {
    isCell(node) {
        return node.type === 'cell';
    }
    isRow(node) {
        return node.type === 'row' || node.type === 'item';
    }
    isDisabled(item) {
        var _item_props;
        return this.disabledBehavior === 'all' && (((_item_props = item.props) === null || _item_props === void 0 ? void 0 : _item_props.isDisabled) || this.disabledKeys.has(item.key));
    }
    findPreviousKey(fromKey, pred) {
        let key = fromKey != null ? this.collection.getKeyBefore(fromKey) : this.collection.getLastKey();
        while(key != null){
            let item = this.collection.getItem(key);
            if (!this.isDisabled(item) && (!pred || pred(item))) return key;
            key = this.collection.getKeyBefore(key);
        }
    }
    findNextKey(fromKey, pred) {
        let key = fromKey != null ? this.collection.getKeyAfter(fromKey) : this.collection.getFirstKey();
        while(key != null){
            let item = this.collection.getItem(key);
            if (!this.isDisabled(item) && (!pred || pred(item))) return key;
            key = this.collection.getKeyAfter(key);
        }
    }
    getKeyBelow(key) {
        let startItem = this.collection.getItem(key);
        if (!startItem) return;
        // If focus was on a cell, start searching from the parent row
        if (this.isCell(startItem)) key = startItem.parentKey;
        // Find the next item
        key = this.findNextKey(key);
        if (key != null) {
            // If focus was on a cell, focus the cell with the same index in the next row.
            if (this.isCell(startItem)) {
                let item = this.collection.getItem(key);
                return (0, $kbsd1$getNthItem)((0, $kbsd1$getChildNodes)(item, this.collection), startItem.index).key;
            }
            // Otherwise, focus the next row
            if (this.focusMode === 'row') return key;
        }
    }
    getKeyAbove(key) {
        let startItem = this.collection.getItem(key);
        if (!startItem) return;
        // If focus is on a cell, start searching from the parent row
        if (this.isCell(startItem)) key = startItem.parentKey;
        // Find the previous item
        key = this.findPreviousKey(key);
        if (key != null) {
            // If focus was on a cell, focus the cell with the same index in the previous row.
            if (this.isCell(startItem)) {
                let item = this.collection.getItem(key);
                return (0, $kbsd1$getNthItem)((0, $kbsd1$getChildNodes)(item, this.collection), startItem.index).key;
            }
            // Otherwise, focus the previous row
            if (this.focusMode === 'row') return key;
        }
    }
    getKeyRightOf(key) {
        let item = this.collection.getItem(key);
        if (!item) return;
        // If focus is on a row, focus the first child cell.
        if (this.isRow(item)) {
            let children = (0, $kbsd1$getChildNodes)(item, this.collection);
            return this.direction === 'rtl' ? (0, $kbsd1$getLastItem)(children).key : (0, $kbsd1$getFirstItem)(children).key;
        }
        // If focus is on a cell, focus the next cell if any,
        // otherwise focus the parent row.
        if (this.isCell(item)) {
            let parent = this.collection.getItem(item.parentKey);
            let children = (0, $kbsd1$getChildNodes)(parent, this.collection);
            let next = this.direction === 'rtl' ? (0, $kbsd1$getNthItem)(children, item.index - 1) : (0, $kbsd1$getNthItem)(children, item.index + 1);
            if (next) return next.key;
            // focus row only if focusMode is set to row
            if (this.focusMode === 'row') return item.parentKey;
            return this.direction === 'rtl' ? this.getFirstKey(key) : this.getLastKey(key);
        }
    }
    getKeyLeftOf(key) {
        let item = this.collection.getItem(key);
        if (!item) return;
        // If focus is on a row, focus the last child cell.
        if (this.isRow(item)) {
            let children = (0, $kbsd1$getChildNodes)(item, this.collection);
            return this.direction === 'rtl' ? (0, $kbsd1$getFirstItem)(children).key : (0, $kbsd1$getLastItem)(children).key;
        }
        // If focus is on a cell, focus the previous cell if any,
        // otherwise focus the parent row.
        if (this.isCell(item)) {
            let parent = this.collection.getItem(item.parentKey);
            let children = (0, $kbsd1$getChildNodes)(parent, this.collection);
            let prev = this.direction === 'rtl' ? (0, $kbsd1$getNthItem)(children, item.index + 1) : (0, $kbsd1$getNthItem)(children, item.index - 1);
            if (prev) return prev.key;
            // focus row only if focusMode is set to row
            if (this.focusMode === 'row') return item.parentKey;
            return this.direction === 'rtl' ? this.getLastKey(key) : this.getFirstKey(key);
        }
    }
    getFirstKey(key, global) {
        let item;
        if (key != null) {
            item = this.collection.getItem(key);
            if (!item) return;
            // If global flag is not set, and a cell is currently focused,
            // move focus to the first cell in the parent row.
            if (this.isCell(item) && !global) {
                let parent = this.collection.getItem(item.parentKey);
                return (0, $kbsd1$getFirstItem)((0, $kbsd1$getChildNodes)(parent, this.collection)).key;
            }
        }
        // Find the first row
        key = this.findNextKey();
        // If global flag is set (or if focus mode is cell), focus the first cell in the first row.
        if (key != null && item && this.isCell(item) && global || this.focusMode === 'cell') {
            let item = this.collection.getItem(key);
            key = (0, $kbsd1$getFirstItem)((0, $kbsd1$getChildNodes)(item, this.collection)).key;
        }
        // Otherwise, focus the row itself.
        return key;
    }
    getLastKey(key, global) {
        let item;
        if (key != null) {
            item = this.collection.getItem(key);
            if (!item) return;
            // If global flag is not set, and a cell is currently focused,
            // move focus to the last cell in the parent row.
            if (this.isCell(item) && !global) {
                let parent = this.collection.getItem(item.parentKey);
                let children = (0, $kbsd1$getChildNodes)(parent, this.collection);
                return (0, $kbsd1$getLastItem)(children).key;
            }
        }
        // Find the last row
        key = this.findPreviousKey();
        // If global flag is set (or if focus mode is cell), focus the last cell in the last row.
        if (key != null && item && this.isCell(item) && global || this.focusMode === 'cell') {
            let item = this.collection.getItem(key);
            let children = (0, $kbsd1$getChildNodes)(item, this.collection);
            key = (0, $kbsd1$getLastItem)(children).key;
        }
        // Otherwise, focus the row itself.
        return key;
    }
    getItem(key) {
        return this.ref.current.querySelector(`[data-key="${CSS.escape(key.toString())}"]`);
    }
    getItemRect(key) {
        var _this_layout_getLayoutInfo;
        if (this.layout) return (_this_layout_getLayoutInfo = this.layout.getLayoutInfo(key)) === null || _this_layout_getLayoutInfo === void 0 ? void 0 : _this_layout_getLayoutInfo.rect;
        let item = this.getItem(key);
        if (item) return new (0, $kbsd1$Rect)(item.offsetLeft, item.offsetTop, item.offsetWidth, item.offsetHeight);
    }
    getPageHeight() {
        var _this_layout_virtualizer, _this_ref_current, _this_ref;
        if (this.layout) return (_this_layout_virtualizer = this.layout.virtualizer) === null || _this_layout_virtualizer === void 0 ? void 0 : _this_layout_virtualizer.visibleRect.height;
        return (_this_ref = this.ref) === null || _this_ref === void 0 ? void 0 : (_this_ref_current = _this_ref.current) === null || _this_ref_current === void 0 ? void 0 : _this_ref_current.offsetHeight;
    }
    getContentHeight() {
        var _this_ref_current, _this_ref;
        if (this.layout) return this.layout.getContentSize().height;
        return (_this_ref = this.ref) === null || _this_ref === void 0 ? void 0 : (_this_ref_current = _this_ref.current) === null || _this_ref_current === void 0 ? void 0 : _this_ref_current.scrollHeight;
    }
    getKeyPageAbove(key) {
        let itemRect = this.getItemRect(key);
        if (!itemRect) return null;
        let pageY = Math.max(0, itemRect.maxY - this.getPageHeight());
        while(itemRect && itemRect.y > pageY){
            key = this.getKeyAbove(key);
            itemRect = this.getItemRect(key);
        }
        return key;
    }
    getKeyPageBelow(key) {
        let itemRect = this.getItemRect(key);
        if (!itemRect) return null;
        let pageHeight = this.getPageHeight();
        let pageY = Math.min(this.getContentHeight(), itemRect.y + pageHeight);
        while(itemRect && itemRect.maxY < pageY){
            let nextKey = this.getKeyBelow(key);
            itemRect = this.getItemRect(nextKey);
            // Guard against case where maxY of the last key is barely less than pageY due to rounding
            // and thus it attempts to set key to null
            if (nextKey != null) key = nextKey;
        }
        return key;
    }
    getKeyForSearch(search, fromKey) {
        if (!this.collator) return null;
        let collection = this.collection;
        let key = fromKey !== null && fromKey !== void 0 ? fromKey : this.getFirstKey();
        // If the starting key is a cell, search from its parent row.
        let startItem = collection.getItem(key);
        if (startItem.type === 'cell') key = startItem.parentKey;
        let hasWrapped = false;
        while(key != null){
            let item = collection.getItem(key);
            // check row text value for match
            if (item.textValue) {
                let substring = item.textValue.slice(0, search.length);
                if (this.collator.compare(substring, search) === 0) {
                    if (this.isRow(item) && this.focusMode === 'cell') return (0, $kbsd1$getFirstItem)((0, $kbsd1$getChildNodes)(item, this.collection)).key;
                    return item.key;
                }
            }
            key = this.findNextKey(key);
            // Wrap around when reaching the end of the collection
            if (key == null && !hasWrapped) {
                key = this.getFirstKey();
                hasWrapped = true;
            }
        }
        return null;
    }
    constructor(options){
        this.collection = options.collection;
        this.disabledKeys = options.disabledKeys;
        this.disabledBehavior = options.disabledBehavior || 'all';
        this.ref = options.ref;
        this.direction = options.direction;
        this.collator = options.collator;
        this.layout = options.layout;
        this.focusMode = options.focusMode || 'row';
    }
}


export {$d1c300d9c497e402$export$de9feff04fda126e as GridKeyboardDelegate};
//# sourceMappingURL=GridKeyboardDelegate.module.js.map
