/*!
 * Connect - TypeORM
 * Copyright(c) 2012 TJ Holowaychuk <tj@vision-media.ca>
 * Copyright(c) 2017, 2018 makepost <makepost@firemail.cc>
 * Copyright(c) 2018 Nathan Phillip Brink <ohnobinki@ohnopublishing.net>
 * MIT Licensed
 */
import { SessionOptions, Store } from "express-session";
import { Repository } from "typeorm";
import { ISession } from "../../domain/Session/ISession";
export declare type Ttl = number | ((store: TypeormStore, sess: any, sid?: string) => number);
export declare class TypeormStore extends Store {
    private cleanupLimit;
    private debug;
    private limitSubquery;
    private onError;
    private repository;
    private ttl;
    /**
     * Initializes TypeormStore with the given `options`.
     */
    constructor(options?: Partial<SessionOptions & {
        cleanupLimit: number;
        limitSubquery: boolean;
        onError: (s: TypeormStore, e: Error) => void;
        ttl: Ttl;
    }>);
    connect(repository: Repository<ISession>): this;
    /**
     * Attempts to fetch session by the given `sid`.
     */
    get: (sid: string, fn: (error?: any, result?: any) => void) => void;
    /**
     * Commits the given `sess` object associated with the given `sid`.
     */
    set: (sid: string, sess: any, fn?: ((error?: any) => void) | undefined) => void;
    /**
     * Destroys the session associated with the given `sid`.
     */
    destroy: (sid: string | string[], fn?: ((error?: any) => void) | undefined) => void;
    /**
     * Refreshes the time-to-live for the session with the given `sid`.
     */
    touch: (sid: string, sess: any, fn?: ((error?: any) => void) | undefined) => void;
    /**
     * Fetches all sessions.
     */
    all: (fn: (error: any, result: any) => void) => void;
    private createQueryBuilder;
    private getTTL;
    private handleError;
}
